IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SPLIT_STRING_IEN_WARD_BED]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[SPLIT_STRING_IEN_WARD_BED]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[SPLIT_STRING_IEN_WARD_BED]
(@STR NVARCHAR(MAX), @DELIM CHAR(1))  

RETURNS @TMP TABLE 
(
	ID INT IDENTITY PRIMARY KEY,
	IEN NVARCHAR(50),
	WARD_UID UNIQUEIDENTIFIER,
	BED_UID UNIQUEIDENTIFIER
)

AS 
BEGIN

	IF @STR IS NULL OR @DELIM IS NULL RETURN;

	DECLARE @IEN NVARCHAR(50), @WARD_UID UNIQUEIDENTIFIER, @BED_UID UNIQUEIDENTIFIER, @I INT, @J INT, @K INT
	SET @I = 1
	SET @K = 1
	
	WHILE 1=1
	BEGIN
		IF @I > LEN(@STR) BREAK
		
		--IEN
		SET @J = CHARINDEX(@DELIM, @STR, @I)
		IF @J = 0 SET @J = LEN(@STR) + 1
		SET @IEN = RTRIM(LTRIM(SUBSTRING(@STR, @I, @J-@I)))
		SET @I = @J + 1
		
		--WARD_UID
		SET @J = CHARINDEX(@DELIM, @STR, @I)
		IF @J = 0 SET @J = LEN(@STR) + 1
		SET @WARD_UID = RTRIM(LTRIM(SUBSTRING(@STR, @I, @J-@I)))
		SET @I = @J + 1
		
		--BED_UID
		SET @J = CHARINDEX(@DELIM, @STR, @I)
		IF @J = 0 SET @J = LEN(@STR) + 1
		SET @BED_UID = RTRIM(LTRIM(SUBSTRING(@STR, @I, @J-@I)))
		SET @I = @J + 1

		INSERT INTO @TMP 
			(IEN, WARD_UID, BED_UID)
		VALUES
			(@IEN, @WARD_UID, @BED_UID)

	END

RETURN 

END
GO